#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\hawkins\hud;
#include user_scripts\mp_patches\hawkins\menuUtils;


SetRandomWeapons()
{
	self.assingedWeapon = [];
	self.assingedWeapon["Sniper"] = level.HumanWeapons["Sniper"][randomInt(level.HumanWeapons["Sniper"].size)];
	self.assingedWeapon["LMG"] = level.HumanWeapons["LMG"][randomInt(level.HumanWeapons["LMG"].size)];
	self.assingedWeapon["AR"] = level.HumanWeapons["AR"][randomInt(level.HumanWeapons["AR"].size)];
	self.assingedWeapon["MachinePistol"] = level.HumanWeapons["MachinePistol"][randomInt(level.HumanWeapons["MachinePistol"].size)];
	
	//Other Stuff
	self.at1 = [];
	self.ATW = [];
	self.ATW[0] = 0;
	self.ATW[1] = 0;
	self.ATW[2] = 0;
	self.at1[0] = "none";
	self.at1[1] = "none";
	self.at1[2] = "none";
	self.CTW = 0;
}

doBotMenuScroll(){
	self endon("disconnect");
	self endon("death");
	while(isalive(self))
	{

		self thread ShowMenu();
		self playlocalsound("missile_locking");
		self.menu++;
		if(self.team=="allies")
		{
			if(self.menu>=level.HM.size)
			{
				self.menu=0;
			}
		}
		else
		{
			if(self.menu>=level.ZM.size)
			{
				self.menu=0;
			}
		}
		self notify("update_menu");
		wait 0.025;
	}
}

doMenuScroll()
{
	self endon("disconnect");
	self endon("death");
	while(isalive(self))
	{
		self waittill("buttonPress",button);
		
		if(level.dev)
			iprintln(button + " pushed");
		
		if((button=="CAPS" && common_scripts\utility::is_player_gamepad_enabled() != 1) || (button=="Up" && common_scripts\utility::is_player_gamepad_enabled() == 1))
		{
			if(!self.StoreIdle)
			{
				self thread ShowMenu();
				self playlocalsound("missile_locking");
				self.menu++;
				if(self.team=="allies")
				{
					if(self.menu>=level.HM.size)
					{
						self.menu=0;
					}
				}
				else
				{
					if(self.menu>=level.ZM.size)
					{
						self.menu=0;
					}
				}
			}
			else
			{
				self thread ShowMenu();
				self playlocalsound("missile_locking");
			}
			self notify("update_menu");
		}
		wait 0.060;
	}
}

ClientWaitButtons() 
{
    buttons = strTok("LeanR|+leanright,LeanL|+leanleft,CAPS|+mlook,Left|+actionslot 3,Right|+actionslot 4,Up|+actionslot 1,Down|+actionslot 2,X|+gostand,R3|+melee,O|+stance,R|+reload,UR|+usereload",","); 
    foreach(button in buttons) 
    { 
        btn = strTok(button,"|"); 
        self thread monitorWaitButtons(btn[0],btn[1]); 
    } 
} 
monitorWaitButtons(button,action) 
{ 
	self endon("disconnect");
	
    self notifyOnPlayerCommand(button,action); 
    for(;;) 
    { 
        self waittillmatch(button); 
        self notify("buttonPress",button);
    } 
}


ClientCheckButtons()
{
	self endon("disconnect");
	self endon("death");
	
	self.buttonAction = strTok("+smoke|+melee|+breath_sprint|+actionslot 3|+actionslot 4","|");
	self.buttonPressed = [];
	
	for(i = 0; i < self.buttonAction.size; i++)
	{
		self.buttonPressed[self.buttonAction[i]] = false;
		self thread monitorCheckButtons(i);
	}
}

//2nd Button Monitoring. Probably need to combine the two
monitorCheckButtons(buttonIndex)
{
	self endon("disconnect");

	self notifyOnPlayerCommand("action_made_"+self.buttonAction[buttonIndex],self.buttonAction[buttonIndex]);
	for(;;)
	{
		self waittill("action_made_"+self.buttonAction[buttonIndex]);

		self.buttonPressed[self.buttonAction[buttonIndex]] = true;
		wait 0.05;
		self.buttonPressed[self.buttonAction[buttonIndex]] = false;
	}
}
isButtonPressed(actionID)
{
	if(self.buttonPressed[actionID])
	{
		self.buttonPressed[actionID] = false;
		return true;
	}
	return false;
}

setPlayersDvar(dvar, value){
	foreach(player in level.players)
		player setClientDvar(dvar, value);
}

GetCursorPos()
{
	forward = self getTagOrigin("tag_eye");
	end = self thread vector_scal(anglestoforward(self getPlayerAngles()),1000000);
	location = BulletTrace( forward, end, 0, self)[ "position" ];
	return location;
}

vector_scal(vec, scale)
{
	vec = (vec[0] * scale, vec[1] * scale, vec[2] * scale);
	return vec;
}

monitorHumanEarnings()
{
	self endon("disconnect");
	self endon("death");
	self.zKills = self.kills;
	oldassists = self.assists;
	self.hst = self.headshotz;
	for(;;)
	{
		if(self.assists - oldassists > 0)
		{
			self.money += 35;
			oldassists = self.assists;
		}
		wait 0.1;
	}
}
monitorZombiesEarnings()
{
	self endon("disconnect");
	self endon("death");
	for(;;)
	{
		if(self.kills - self.zKills > 0)
		{
			self.money += 150;
			self.zKills++;
			
		}
		if(self.deaths - self.zDeaths > 0)
		{
			self.money += 50;
			self.zDeaths++;
			
		}
		if(self.suicides - self.zSuicides > 0)
		{
			self.money -= 50;
			self.zSuicides++;
			
		}
		wait 0.025;
	}
}

MonitorDeaths()
{
	self endon("disconnect");
	
	if(level.gameState != "playing")
		return;
		
	self waittill_any("death", "disconnect");

	if(isDefined(self.whd))
		self.whd Destroy();
	if(isDefined(self.shd))
		self.shd Destroy();
	if(isDefined(self.cbc))
		self.cbc Destroy();
}

monitorAllowedAttachments(){
	self endon("death");
	oldSlot = [];
	while(isAlive(self)){
		if(self.weaponSlot["Secondary"] != oldSlot["Secondary"]){
			oldSlot["Secondary"] = self.weaponSlot["Secondary"];
			if(isSubStr(self.weaponSlot["Secondary"], "ranger" ) || isSubStr( self.weaponSlot["Secondary"], "model1887" )){
				if(isSubStr(self.weaponSlot["Secondary"], "akimbo" ))
					self setClientDvar("ui_akimbo_1", 0);
				else
					self setClientDvar("ui_akimbo_1", 1);
				self setClientDvar("ui_reflex_1", 0);
				self setClientDvar("ui_xmag_1", 0);
			}
			else{
				self setClientDvar("ui_akimbo_1", 0);
			}
		}
		wait 0.25;
	}
}

addAttachment(baseName, oldAttachment, newAttachment)
{
	ammo = self GetWeaponAmmoStock(baseName);
	self takeWeapon(baseName);
	if(isSubStr(baseName, "heartbeat" ) && oldAttachment == "none")
		oldAttachment = "heartbeat";
	basename = strtok(baseName, "_");
	gun = buildWeaponName(basename[1], oldAttachment, newAttachment);
	if(isSubStr(gun, "akimbo" ))
		self giveWeapon(gun, randomint(8), true);
	else
		self giveWeapon(gun, randomint(8), false);
	self SetWeaponAmmoStock(gun, ammo );
	wait 0.05;
	self switchToWeapon(gun);
	self iPrintlnText("^2Weapon Upgraded!");
	return gun;
}

/*
fmj = buildWeaponName(basename[1], self.at1[self.CTW], "fmj");
reflex = buildWeaponName(basename[1], self.at1[self.CTW], "reflex");
silencer = buildWeaponName(basename[1], self.at1[self.CTW], "silencer");
xmag = buildWeaponName(basename[1], self.at1[self.CTW], "xmag");
rof = buildWeaponName(basename[1], self.at1[self.CTW], "rof");

ClientWaitButtons() 
{
    buttons = strTok("CAPS|+mlook,Left|+actionslot 3,Right|+actionslot 4,Up|+actionslot 1,Down|+actionslot 2,X|+gostand,R3|+melee,O|+stance,R|+reload,UR|+usereload",","); 
    foreach(button in buttons) 
    { 
        btn = strTok(button,"|"); 
        self thread monitorWaitButtons(btn[0],btn[1]); 
    } 
} 

*/

canDoXmag(weapon){
	if(isSubStr(weapon, "xmag")){
		return false;
	}
	else if(
		isSubStr(weapon, level.customWeapon["raygun"]) ||
		isSubStr(weapon, "h2_pp2000_mp") ||
		isSubStr(weapon, "h2_glock_mp") ||
		isSubStr(weapon, "h2_beretta393_mp") ||
		isSubStr(weapon, "h2_tmp_mp") ||
		isSubStr(weapon, "h2_spas12_mp") ||
		isSubStr(weapon, "h2_aa12_mp") ||
		isSubStr(weapon, "h2_striker_mp") ||
		isSubStr(weapon, "h2_m1014_mp") ||
		isSubStr(weapon, "h2_model1887_mp") ||
		isSubStr(weapon, "h2_m4_mp") ||
		isSubStr(weapon, "h2_famas_mp") ||
		isSubStr(weapon, "h2_scar_mp") ||
		isSubStr(weapon, "h2_tavor_mp") ||
		isSubStr(weapon, "h2_fal_mp") ||
		isSubStr(weapon, "h2_m16_mp") ||
		isSubStr(weapon, "h2_masada_mp") ||
		isSubStr(weapon, "h2_fn2000_mp") ||
		isSubStr(weapon, "h2_ak47_mp") ||
		isSubStr(weapon, "h2_mp5k_mp") ||
		isSubStr(weapon, "h2_ump45_mp") ||
		isSubStr(weapon, "h2_kriss_mp") ||
		isSubStr(weapon, "h2_p90_mp") ||
		isSubStr(weapon, "h2_uzi_mp") ||
		isSubStr(weapon, "h2_cheytac_mp") ||
		isSubStr(weapon, "h2_barrett_mp") ||
		isSubStr(weapon, "h2_wa2000_mp") ||
		isSubStr(weapon, "h2_m21_mp") ||
		isSubStr(weapon, "h2_m40a3_mp") ||
		isSubStr(weapon, "h2_ak74u_mp") ||
		isSubStr(weapon, "h2_sa80_mp") ||
		isSubStr(weapon, "h2_rpd_mp") ||
		isSubStr(weapon, "h2_mg4_mp") ||
		isSubStr(weapon, "h2_aug_mp") ||
		isSubStr(weapon, "h2_m240_mp") ||
		isSubStr(weapon, "h2_usp_mp") ||
		isSubStr(weapon, "h2_m9_mp") ||
		isSubStr(weapon, "h2_colt45_mp") ||
		isSubStr(weapon, "h2_deserteagle_mp") ||
		isSubStr(weapon, "h2_ranger_mp")
	)
		return true;
	else
		return false;
}

canDoReflex(weapon){
	if(isSubStr(weapon, "reflex") ||
	   isSubStr(weapon, "akimbo")
	){
		return false;
	}
	else if(
		isSubStr(weapon, "h2_pp2000_mp") ||
		isSubStr(weapon, "h2_glock_mp") ||
		isSubStr(weapon, "h2_beretta393_mp") ||
		isSubStr(weapon, "h2_tmp_mp") ||
		isSubStr(weapon, "h2_spas12_mp") ||
		isSubStr(weapon, "h2_aa12_mp") ||
		isSubStr(weapon, "h2_striker_mp") ||
		isSubStr(weapon, "h2_m1014_mp") ||
		isSubStr(weapon, "h2_model1887_mp") ||
		isSubStr(weapon, "h2_m4_mp") ||
		isSubStr(weapon, "h2_famas_mp") ||
		isSubStr(weapon, "h2_scar_mp") ||
		isSubStr(weapon, "h2_tavor_mp") ||
		isSubStr(weapon, "h2_fal_mp") ||
		isSubStr(weapon, "h2_m16_mp") ||
		isSubStr(weapon, "h2_masada_mp") ||
		isSubStr(weapon, "h2_fn2000_mp") ||
		isSubStr(weapon, "h2_ak47_mp") ||
		isSubStr(weapon, "h2_mp5k_mp") ||
		isSubStr(weapon, "h2_ump45_mp") ||
		isSubStr(weapon, "h2_kriss_mp") ||
		isSubStr(weapon, "h2_p90_mp") ||
		isSubStr(weapon, "h2_uzi_mp") ||
		isSubStr(weapon, "h2_cheytac_mp") ||
		isSubStr(weapon, "h2_barrett_mp") ||
		isSubStr(weapon, "h2_wa2000_mp") ||
		isSubStr(weapon, "h2_m21_mp") ||
		isSubStr(weapon, "h2_m40a3_mp") ||
		isSubStr(weapon, "h2_ak74u_mp") ||
		isSubStr(weapon, "h2_sa80_mp") ||
		isSubStr(weapon, "h2_rpd_mp") ||
		isSubStr(weapon, "h2_mg4_mp") ||
		isSubStr(weapon, "h2_aug_mp") ||
		isSubStr(weapon, "h2_m240_mp") ||
		isSubStr(weapon, "h2_usp_mp") ||
		isSubStr(weapon, "h2_m9_mp") ||
		isSubStr(weapon, "h2_colt45_mp") ||
		isSubStr(weapon, "h2_deserteagle_mp") ||
		isSubStr(weapon, "h2_ranger_mp")
	)
		return true;
	else
		return false;
}

canDoSilencer(weapon){
	if(isSubStr(weapon, "silencer")
	){
		return false;
	}
	else if(
		isSubStr(weapon, "h2_pp2000_mp") ||
		isSubStr(weapon, "h2_glock_mp") ||
		isSubStr(weapon, "h2_beretta393_mp") ||
		isSubStr(weapon, "h2_tmp_mp") ||
		isSubStr(weapon, "h2_spas12_mp") ||
		isSubStr(weapon, "h2_aa12_mp") ||
		isSubStr(weapon, "h2_striker_mp") ||
		isSubStr(weapon, "h2_m1014_mp") ||
		isSubStr(weapon, "h2_model1887_mp") ||
		isSubStr(weapon, "h2_m4_mp") ||
		isSubStr(weapon, "h2_famas_mp") ||
		isSubStr(weapon, "h2_scar_mp") ||
		isSubStr(weapon, "h2_tavor_mp") ||
		isSubStr(weapon, "h2_fal_mp") ||
		isSubStr(weapon, "h2_m16_mp") ||
		isSubStr(weapon, "h2_masada_mp") ||
		isSubStr(weapon, "h2_fn2000_mp") ||
		isSubStr(weapon, "h2_ak47_mp") ||
		isSubStr(weapon, "h2_mp5k_mp") ||
		isSubStr(weapon, "h2_ump45_mp") ||
		isSubStr(weapon, "h2_kriss_mp") ||
		isSubStr(weapon, "h2_p90_mp") ||
		isSubStr(weapon, "h2_uzi_mp") ||
		isSubStr(weapon, "h2_cheytac_mp") ||
		isSubStr(weapon, "h2_barrett_mp") ||
		isSubStr(weapon, "h2_wa2000_mp") ||
		isSubStr(weapon, "h2_m21_mp") ||
		isSubStr(weapon, "h2_m40a3_mp") ||
		isSubStr(weapon, "h2_ak74u_mp") ||
		isSubStr(weapon, "h2_sa80_mp") ||
		isSubStr(weapon, "h2_rpd_mp") ||
		isSubStr(weapon, "h2_mg4_mp") ||
		isSubStr(weapon, "h2_aug_mp") ||
		isSubStr(weapon, "h2_m240_mp") ||
		isSubStr(weapon, "h2_usp_mp") ||
		isSubStr(weapon, "h2_m9_mp") ||
		isSubStr(weapon, "h2_colt45_mp") ||
		isSubStr(weapon, "h2_deserteagle_mp")
	)
		return true;
	else
		return false;
}

canDoFMJ(weapon){
	if(isSubStr(weapon, "fmj")){
		return false;
	}
	else if(
		isSubStr(weapon, "h2_pp2000_mp") ||
		isSubStr(weapon, "h2_glock_mp") ||
		isSubStr(weapon, "h2_beretta393_mp") ||
		isSubStr(weapon, "h2_tmp_mp") ||
		isSubStr(weapon, "h2_spas12_mp") ||
		isSubStr(weapon, "h2_aa12_mp") ||
		isSubStr(weapon, "h2_striker_mp") ||
		isSubStr(weapon, "h2_m1014_mp") ||
		isSubStr(weapon, "h2_model1887_mp") ||
		isSubStr(weapon, "h2_m4_mp") ||
		isSubStr(weapon, "h2_famas_mp") ||
		isSubStr(weapon, "h2_scar_mp") ||
		isSubStr(weapon, "h2_tavor_mp") ||
		isSubStr(weapon, "h2_fal_mp") ||
		isSubStr(weapon, "h2_m16_mp") ||
		isSubStr(weapon, "h2_masada_mp") ||
		isSubStr(weapon, "h2_fn2000_mp") ||
		isSubStr(weapon, "h2_ak47_mp") ||
		isSubStr(weapon, "h2_mp5k_mp") ||
		isSubStr(weapon, "h2_ump45_mp") ||
		isSubStr(weapon, "h2_kriss_mp") ||
		isSubStr(weapon, "h2_p90_mp") ||
		isSubStr(weapon, "h2_uzi_mp") ||
		isSubStr(weapon, "h2_cheytac_mp") ||
		isSubStr(weapon, "h2_barrett_mp") ||
		isSubStr(weapon, "h2_wa2000_mp") ||
		isSubStr(weapon, "h2_m21_mp") ||
		isSubStr(weapon, "h2_m40a3_mp") ||
		isSubStr(weapon, "h2_ak74u_mp") ||
		isSubStr(weapon, "h2_sa80_mp") ||
		isSubStr(weapon, "h2_rpd_mp") ||
		isSubStr(weapon, "h2_mg4_mp") ||
		isSubStr(weapon, "h2_aug_mp") ||
		isSubStr(weapon, "h2_m240_mp") ||
		isSubStr(weapon, "h2_usp_mp") ||
		isSubStr(weapon, "h2_m9_mp") ||
		isSubStr(weapon, "h2_colt45_mp") ||
		isSubStr(weapon, "h2_deserteagle_mp") ||
		isSubStr(weapon, "h2_ranger_mp")
	)
		return true;
	else
		return false;
}

canDoAkimbo(weapon){
	if(isSubStr(weapon, "reflex") ||
	   isSubStr(weapon, "holo") ||
	   isSubStr(weapon, "akimbo")
	){
		return false;
	}
	else if(
		isSubStr(weapon, "h2_usp_mp") ||
		isSubStr(weapon, "h2_m9_mp") ||
		isSubStr(weapon, "h2_colt45_mp") ||
		isSubStr(weapon, "h2_deserteagle_mp") ||
		isSubStr(weapon, "h2_ranger_mp") ||
		isSubStr(weapon, "h2_model1887_mp") ||
		isSubStr(weapon, "h2_glock_mp") ||
		isSubStr(weapon, "h2_beretta393_mp") ||
		isSubStr(weapon, "h2_p90_mp") ||
		isSubStr(weapon, "h2_uzi_mp") ||
		isSubStr(weapon, "h2_kriss_mp") ||
		isSubStr(weapon, "h2_ump45_mp") ||
		isSubStr(weapon, "h2_mp5k_mp") ||
		isSubStr(weapon, level.customWeapon["raygun"]) ||
		isSubStr(weapon, "h2_tmp_mp")
	)
		return true;
	else
		return false;
}

isValidMenuWeapon(weapon){
	if(
	weapon == level.customWeapon["deserteagle"] ||
	weapon == level.customWeapon["thundergun"] ||
	weapon == level.customWeapon["raygun"] ||
	weapon == level.customWeapon["stingerpro"]
	){
		return false;
	}
	else
		return true;
}

canAttach(weapon){
	if(!isValidMenuWeapon(weapon))
		return false;
	splitname = strtok(weapon, "_");
	if(!isDefined(splitname[3]))
		splitname[3] = "";
	if(!isDefined(splitname[4]))
		splitname[4] = "";

	if(splitname[0] == "h1" || splitname[0] == "h2"){
		if(splitname[3] == "" || splitname[4] == "")
			return true;
		else
			return false;
	}
	else{
		if(splitname[2] == "" || splitname[3] == "")
			return true;
		else
			return false;
	}
}

buildAttachments(attachment1, attachment2){
	//iPrintLn("attachment1"+attachment1);
	//iPrintLn("attachment2"+attachment2);
	if((attachment1 == "reflex" && attachment2 == "xmag") || (attachment1 == "xmag" && attachment2 == "reflex"))
		return "reflex_xmag";
	else if((attachment1 == "fmj" && attachment2 == "reflex") || attachment1 == "reflex" && attachment2 == "fmj")
		return "fmj_reflex";
	else if((attachment1 == "fmj" && attachment2 == "holo") || attachment1 == "holo" && attachment2 == "fmj")
		return "fmj_holo";
	else if((attachment1 == "xmag" && attachment2 == "holo") || attachment1 == "holo" && attachment2 == "xmag")
		return "holo_xmag";
	else if((attachment1 == "holo" && attachment2 == "silencerpistol") || attachment1 == "silencerpistol" && attachment2 == "holo")
		return "holo_silencerpistol";
	else if((attachment1 == "reflex" && attachment2 == "silencerpistol") || attachment1 == "silencerpistol" && attachment2 == "reflex")
		return "reflex_silencerpistol";
	else if((attachment1 == "xmag" && attachment2 == "akimbo") || attachment1 == "akimbo" && attachment2 == "xmag")
		return "akimbo_xmag";
	else if((attachment1 == "fmj" && attachment2 == "akimbo") || attachment1 == "akimbo" && attachment2 == "fmj")
		return "akimbo_fmj";
	else if((attachment1 == "akimbo" && attachment2 == "silencerpistol") || attachment1 == "silencerpistol" && attachment2 == "akimbo")
		return "akimbo_silencerpistol";
	else if((attachment1 == "xmag" && attachment2 == "silencerpistol") || attachment1 == "silencerpistol" && attachment2 == "xmag")
		return "silencerpistol_xmag";
	else if((attachment1 == "reflex" && attachment2 == "silencerar") || attachment1 == "silencerar" && attachment2 == "reflex")
		return "reflex_silencerar";
	else if((attachment1 == "fmj" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "fmj")
		return "fmj_xmag";
	else if((attachment1 == "holo" && attachment2 == "silencerar") || attachment1 == "silencerar" && attachment2 == "holo")
		return "holo_silencerar";
	else if((attachment1 == "acog" && attachment2 == "silencerar") || attachment1 == "silencerar" && attachment2 == "acog")
		return "acog_silencerar";
	else if((attachment1 == "acog" && attachment2 == "fmj") || attachment1 == "fmj" && attachment2 == "acog")
		return "acog_fmj";
	else if((attachment1 == "acog" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "acog")
		return "acog_xmag";
	else if((attachment1 == "silencerar" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "silencerar")
		return "silencerar_xmag";
	else if((attachment1 == "silencersmg" && attachment2 == "akimbo") || attachment1 == "akimbo" && attachment2 == "silencersmg")
		return "akimbo_silencersmg";
	else if((attachment1 == "silencersmg" && attachment2 == "holo") || attachment1 == "holo" && attachment2 == "silencersmg")
		return "holo_silencersmg";
	else if((attachment1 == "silencersmg" && attachment2 == "reflex") || attachment1 == "reflex" && attachment2 == "silencersmg")
		return "reflex_silencersmg";
	else if((attachment1 == "silencersmg" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "silencersmg")
		return "silencersmg_xmag";
	else if((attachment1 == "silencerlmg" && attachment2 == "reflex") || attachment1 == "reflex" && attachment2 == "silencerlmg")
		return "reflex_silencerlmg";
	else if((attachment1 == "silencerlmg" && attachment2 == "holo") || attachment1 == "holo" && attachment2 == "silencerlmg")
		return "holo_silencerlmg";
	else if((attachment1 == "silencerlmg" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "silencerlmg")
		return "silencerlmg_xmag";
	else if((attachment1 == "silencerlmg" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "silencerlmg")
		return "silencersniper_xmag";
	else if((attachment1 == "reflex" && attachment2 == "silencershotgun") || attachment1 == "silencershotgun" && attachment2 == "reflex")
		return "reflex_silencershotgun";
	else if((attachment1 == "holo" && attachment2 == "silencershotgun") || attachment1 == "silencershotgun" && attachment2 == "holo")
		return "holo_silencershotgun";
	else if((attachment1 == "silencershotgun" && attachment2 == "xmag") || attachment1 == "xmag" && attachment2 == "silencershotgun")
		return "silencershotgun_xmag";
	else
		return "none";
}

getWeaponSilencer(weapon){
	silencer = "silencerpistol";
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_secondary_shotgun":
			silencer = "silencershotgun";
		break;
		case "weapon_sniper":
			silencer = "silencersniper";
		break;
		case "weapon_heavy":
			silencer = "silencerlmg";
		break;
		case "weapon_smg":
			silencer = "silencersmg";
		break;
		case "weapon_assault":
			silencer = "silencerar";
		break;
		case "weapon_secondary_machine_pistol":
			silencer = "silencerpistol";
		break;
		case "weapon_pistol":
			silencer = "silencerpistol";
		break;
	}
	return silencer;
}

BuildWeaponWithAttachments(weapon, attachment){
	//iPrintLn(weapon);
	//if(isSubStr(weapon, attachment))
	//	return weapon;


	splitname = strtok(weapon, "_");
	weaponBaseName = splitname[0];

	if(attachment == "silencer")
		attachment = getWeaponSilencer(weapon);

	if(splitname[0] == "h1" || splitname[0] == "h2"){
		//splitname[2] is "mp"
		weaponName = "";
		//iPrintLn(splitname[3]);
		if(splitname[3] == ""){
			weaponName = splitname[0]+"_"+splitname[1]+"_"+splitname[2]+"_"+attachment;
		}
		else{
			weaponName = splitname[0]+"_"+splitname[1]+"_"+splitname[2]+"_"+buildAttachments(splitname[3],attachment);
		}
		return weaponName;
	}
	else{
		splitname[0] = splitname[0];
	}
		
	/*
	splitname = strtok(weapon, "_");
	startName = "";
	weaponBaseName = splitname[0];
	if(splitname[0] == "h1" || splitname[0] == "h2"){
		weaponBaseName = splitname[1];
		startName = splitname[0];
	}

	
	else if(attachment == "xmag"){
		weaponList = strTok("h2_usp_mp,h2_coltanaconda_mp,h2_m9_mp,h2_colt45_mp,h2_deserteagle_mp,h2_ranger_mp,h2_pp2000_mp,h2_glock_mp,h2_beretta393_mp,h2_tmp_mp,h2_model1887_mp,h2_mp5k_mp,h2_ump45_mp,h2_kriss_mp,h2_p90_mp,h2_uzi_mp,h2_kriss",",");
		foreach(weapons in weaponList){
			if(isSubStr( weapon, weapons )){
				return weapon+"_"+attachment;
			}
		}
		return weapon;
	}
	else if(attachment == "fmj"){
		weaponList = strTok("h2_usp_mp,h2_coltanaconda_mp,h2_m9_mp,h2_colt45_mp,h2_deserteagle_mp,h2_ranger_mp,h2_pp2000_mp,h2_glock_mp,h2_beretta393_mp,h2_tmp_mp,h2_model1887_mp,h2_mp5k_mp,h2_ump45_mp,h2_kriss_mp,h2_p90_mp,h2_uzi_mp,h2_kriss",",");
		foreach(weapons in weaponList){
			if(isSubStr( weapon, weapons )){
				if(isSubStr( weapon, "fmj" )){
					basename = strtok(weapon, "_fmj");
					return basename[0]+"_"+attachment+"_fmj";
				}
				else if(isSubStr( weapon, "akimbo" )){
					basename = strtok(weapon, "_akimbo");
					return basename[0]+"_"+attachment+"_akimbo";
				}
				else
					return weapon+"_"+attachment;
			}
		}
		return weapon;
	}
	else if(attachment == "akimbo"){
		weaponList = strTok("h2_ak47u_mp,h2_usp_mp,h2_coltanaconda_mp,h2_m9_mp,h2_colt45_mp,h2_deserteagle_mp,h2_ranger_mp,h2_pp2000_mp,h2_glock_mp,h2_beretta393_mp,h2_tmp_mp,h2_model1887_mp,h2_mp5k_mp,h2_ump45_mp,h2_kriss_mp,h2_p90_mp,h2_uzi_mp,h2_kriss",",");
		foreach(weapons in weaponList){
			if(isSubStr( weapon, weapons )){
				if(isSubStr( weapon, "_fmj" )){
					basename = strtok(weapon, "_fmj");
					return basename[0]+"_"+attachment+"_fmj";
				}
				else
					return weapon+"_"+attachment;
			}
		}
		return weapon;
	}*/
}

buildWeaponName( baseName, attachment1, attachment2 )
{
	if ( !isDefined( level.letterToNumber ) ){
		level.letterToNumber = makeLettersToNumbers();
	}
	
	if ( getDvarInt ( "scr_game_perks" ) == 0 )
	{
		attachment2 = "none";

		if ( baseName == "onemanarmy" ){
			return ( "beretta_mp" );
		}
	}

	weaponName = baseName;
	attachments = [];

	if ( attachment1 != "none" && attachment2 != "none" )
	{
		if ( level.letterToNumber[attachment1[0]] < level.letterToNumber[attachment2[0]] )
		{
			
			attachments[0] = attachment1;
			attachments[1] = attachment2;
			
		}
		else if ( level.letterToNumber[attachment1[0]] == level.letterToNumber[attachment2[0]] )
		{
			if ( level.letterToNumber[attachment1[1]] < level.letterToNumber[attachment2[1]] )
			{
				attachments[0] = attachment1;
				attachments[1] = attachment2;
			}
			else
			{
				attachments[0] = attachment2;
				attachments[1] = attachment1;
			}	
		}
		else
		{
			attachments[0] = attachment2;
			attachments[1] = attachment1;
		}		
	}
	else if ( attachment1 != "none" )
	{
		attachments[0] = attachment1;
	}
	else if ( attachment2 != "none" )
	{
		attachments[0] = attachment2;	
	}
	
	foreach ( attachment in attachments )
	{
		weaponName += "_mp_" + attachment;
	}

	return ( weaponName );
}

isValidWeapon( refString )
{
	if ( !isDefined( level.weaponRefs ) )
	{
		level.weaponRefs = [];

		foreach ( weaponRef in level.weaponList ){
			level.weaponRefs[ weaponRef ] = true;
		}
	}

	if ( isDefined( level.weaponRefs[ refString ] ) ){
		return true;
	}

	assertMsg( "Replacing invalid weapon/attachment combo: " + refString );
	
	return false;
}

makeLettersToNumbers()
{
	array = [];
	
	array["a"] = 0;
	array["b"] = 1;
	array["c"] = 2;
	array["d"] = 3;
	array["e"] = 4;
	array["f"] = 5;
	array["g"] = 6;
	array["h"] = 7;
	array["i"] = 8;
	array["j"] = 9;
	array["k"] = 10;
	array["l"] = 11;
	array["m"] = 12;
	array["n"] = 13;
	array["o"] = 14;
	array["p"] = 15;
	array["q"] = 16;
	array["r"] = 17;
	array["s"] = 18;
	array["t"] = 19;
	array["u"] = 20;
	array["v"] = 21;
	array["w"] = 22;
	array["x"] = 23;
	array["y"] = 24;
	array["z"] = 25;
	
	return array;
}

SetCustomScores()
{
	if(!isdefined(self.pers["score"]))
		self.pers["score"]=0;
	if(!isdefined(self.pers["kills"]))
		self.pers["kills"]=0;
	if(!isdefined(self.pers["assists"]))
		self.pers["assists"]=0;
	if(!isdefined(self.pers["deaths"]))
		self.pers["deaths"]=0;
	if(!isdefined(self.pers["suicides"]))
		self.pers["suicides"]=0;
	if(!isdefined(self.pers["headshots"]))
		self.pers["headshots"]=0;
	if(!isdefined(self.score))
		self.score=0;
	if(!isdefined(self.kills))
		self.kills=0;
	if(!isdefined(self.assists))
		self.assists=0;
	if(!isdefined(self.deaths))
		self.deaths=0;
	if(!isdefined(self.suicides))
		self.suicides=0;
	if(!isdefined(self.headshotz))
		self.headshotz=0;
}
ResetAllScores()
{
	self.pers["score"]=0;
	self.pers["kills"]=0;
	self.pers["assists"]=0;
	self.pers["deaths"]=0;
	self.pers["suicides"]=0;
	self.pers["headshots"]=0;
	self.score=0;
	self.kills=0;
	self.assists=0;
	self.deaths=0;
	self.suicides=0;
	self.headshotz=0;
}

monitorPerks()
{
	self endon ( "disconnect" );
	self endon ( "game_ended" );
	self waittill("spawned_player");
	wait 5;
	while(1)
	{
		if(self.humanSkills["thermal"]){
			self ThermalVisionFOFOverlayOn();
		}
		if(self.zombieSkills["thermal"]){
			self ThermalVisionFOFOverlayOn();
		}
		if(self.humanSkills["uav"] == 1 && !self.hasRadar){
			self.radarMode = "fast_radar";
			self.hasRadar = true;
		}
		if(self.perkz["steadyaim"] == 1){
			if(!_hasPerk("specialty_bulletaccuracy")){
				maps\mp\_utility::giveperk("specialty_bulletaccuracy", 0 );
			}
		}
		if(self.perkz["steadyaim"] == 2){
			if(!_hasPerk("specialty_bulletaccuracy")){
				maps\mp\_utility::giveperk("specialty_bulletaccuracy", 0 );
			}
			if(!_hasPerk("specialty_holdbreath")){
            	maps\mp\_utility::giveperk("specialty_holdbreath", 0 );
			}
			self player_recoilScaleOn(0);
		}
		if(self.perkz["sleightofhand"] == 1){
			if(!_hasPerk("specialty_fastreload")){
				maps\mp\_utility::giveperk( "specialty_fastreload", 0 );
			}
		}
		if(self.perkz["sleightofhand"] == 2){
			if(!_hasPerk("specialty_fastreload")){
				maps\mp\_utility::giveperk( "specialty_fastreload", 0 );
			}
			if(!_hasPerk("specialty_quickdraw")){
				maps\mp\_utility::giveperk( "specialty_quickdraw", 0 );
			}
		}
		if(self.perkz["sitrep"] == 1){
			if(!_hasPerk("specialty_detectexplosive")){
				maps\mp\_utility::giveperk("specialty_detectexplosive", 0 );
			}
		}
		if(self.perkz["sitrep"] == 2){
			if(!_hasPerk("specialty_detectexplosive")){
				maps\mp\_utility::giveperk("specialty_detectexplosive", 0 );
			}
			if(!_hasPerk("specialty_selectivehearing")){
				maps\mp\_utility::giveperk("specialty_selectivehearing", 0 );
			}
		}
		if(self.perkz["stoppingpower"] == 1){
			if(!_hasPerk("specialty_bulletdamage")){
				maps\mp\_utility::giveperk("specialty_bulletdamage", 0 );
			}
		}
		if(self.perkz["stoppingpower"] == 2){
			if(!_hasPerk("specialty_bulletdamage")){
				maps\mp\_utility::giveperk("specialty_bulletdamage", 0 );
			}
			if(!_hasPerk("specialty_armorpiercing")){
				maps\mp\_utility::giveperk("specialty_armorpiercing", 0 );
			}
		}
		if(self.perkz["coldblooded"] == 1){
			if(!_hasPerk("specialty_radarimmune")){
				maps\mp\_utility::giveperk("specialty_radarimmune");
			}
		}
		if(self.perkz["coldblooded"] == 2){
			if(!_hasPerk("specialty_radarimmune")){
				maps\mp\_utility::giveperk("specialty_radarimmune");
			}
			if(!_hasPerk("specialty_spygame")){
				maps\mp\_utility::giveperk("specialty_spygame");
			}
		}
		if(self.perkz["ninja"] == 1){
			if(!_hasPerk("specialty_heartbreaker")){
				maps\mp\_utility::giveperk("specialty_heartbreaker", 0 );
			}
		}
		if(self.perkz["ninja"] == 2){
			if(!_hasPerk("specialty_heartbreaker")){
				maps\mp\_utility::giveperk("specialty_heartbreaker", 0 );
			}
			if(!_hasPerk("specialty_quieter")){
				maps\mp\_utility::giveperk("specialty_quieter", 0 );
			}
		}
		if(self.perkz["lightweight"] == 1){
			if(!_hasPerk("specialty_lightweight")){
				maps\mp\_utility::giveperk("specialty_lightweight", 0 );
			}
			self.speedScale = 1.2;
		}
		if(self.perkz["lightweight"] == 2){
			if(!_hasPerk("specialty_lightweight")){
				maps\mp\_utility::giveperk("specialty_lightweight", 0 );
			}
			if(!_hasPerk("specialty_fastsprintrecovery")){
				maps\mp\_utility::giveperk("specialty_fastsprintrecovery", 0 );
			}
			self.speedScale = 1.5;
		}
		if(self.team == "allies"){
			if(!level.slowHumans)
				self setMoveSpeedScale(self.speedScale);
		}
		else if(self.team == "axis"){
			if(!self.zombieSkills["radio"] && !self.zombieSkills["flame"])
				self setMoveSpeedScale(self.speedScale);
		}
		wait 0.1;
	}
}

WeaponChecking()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	while(isAlive(self))
	{
		if(
		self getCurrentWeapon() != level.zombieknife &&
		self getCurrentWeapon() != "" &&
		self getCurrentWeapon() != "none" &&
		self getCurrentWeapon() != "barrel_mp" &&
		self getCurrentWeapon() != "predator_mp" &&
		self getCurrentWeapon() != "onemanarmy_mp")
		{
			current = self getCurrentWeapon();
			self takeWeapon(current);
			self switchToWeapon(level.zombieknife);
		}
		self waittill_any("weapon_change","reload");
		wait 0.025;
	}
}

OverRider()
{
	for(;;)
	{
		level notify("abort_forfeit");
		level.prematchPeriod=0;
		level.killstreakRewards=0;
		wait 1;
	}
}

doBots(numberOfTestClients)
{
for(i = 0; i < numberOfTestClients; i++)
	{
	ent[i] = addtestclient();
	if (!isdefined(ent[i]))
		{
			wait 1;
			continue;
		}
	ent[i].pers["isBot"] = true;
	ent[i] thread TestClient(i);
	wait 0.2;
	}
}
TestClient(i)
{
	self endon( "disconnect" );
	while(!isdefined(self.pers["team"]))
	{
		wait 1;
		self maps\mp\gametypes\_menus::addToTeam( "allies" );
		self notify("menuresponse", game["menu_team"], "allies");
		wait 0.5;
		self notify("menuresponse", "changeclass", "class3");
	}
}

ResetClientVisions()
{
	foreach(player in level.players)
	{	
		if(player.team == "allies")
			player VisionSetNakedForPlayer(level.humanVision, 1);
		else if(player.team == "axis")
			player VisionSetNakedForPlayer(level.zombieVision, 1);
	}
}

disableOpZombieSkills(){
	self.disableMenuOptions = true;
	self setClientDvar("ui_z_invis", 0);
    self setClientDvar("ui_z_radio", 0);
    self setClientDvar("ui_z_flame", 0);
    self setClientDvar("ui_z_slowh", 0);
    self setClientDvar("ui_z_1500hp", 0);
    //self setClientDvar("ui_z_predator", 0);
    self setClientDvar("ui_z_flying", 0);
    self setClientDvar("ui_z_blackouth", 0);
}

enableOpZombieSkills(){
	self.disableMenuOptions = false;
	//self setClientDvar("ui_z_invis", 1);
	self setClientDvar("ui_z_radio", 0);
    //self setClientDvar("ui_z_flame", 1);
    self setClientDvar("ui_z_slowh", 1);
    self setClientDvar("ui_z_1500hp", 1);
    //self setClientDvar("ui_z_predator", 1);
    //self setClientDvar("ui_z_flying", 1);
    //self setClientDvar("ui_z_blackouth", 1);

	self thread enableRoundOptions();
}

playSoundToAll( sound )
{
	assert( isdefined( level.players ) );

	if ( level.splitscreen )
	{
		if ( isdefined( level.players[ 0 ] ) )
			level.players[ 0 ] playLocalSound( sound );
	}
	else
	{
		for ( i = 0; i < level.players.size; i++ )
			level.players[ i ] playLocalSound( sound );
	}
}

setGameDvars()
{
	setDvar("stopspeed", 200);
	setDvar("jump_slowdownEnable", 0);
	setDvar("scr_nukeTimer", 60);
	setDvar("ui_allow_teamchange",1);
	setDvar("g_gametype","war");
	setDvar("ui_gametype","war");
	setDvar("scr_war_scorelimit",0);
	setDvar("scr_war_timelimit",0);
	setDvar("scr_war_waverespawndelay",0);
	setDvar("scr_war_playerrespawndelay",0);
	setDvar("cg_scoreboardPingGraph","1");
	setDvar("ui_showEndOfGame","1");
	setDvar("painVisionTriggerHealth",0);
	setDvar("player_sprintUnlimited",1);
	setDvar("g_teamcolor_axis","1 0.0 00.0");
	setDvar("g_teamcolor_allies","0 0.0 00.0");
	setDvar("cg_drawCrosshair",0);
	setDvar("cg_drawCrosshairNames",1);
	setDvar("perk_blastShield","1");
	setdvar("g_compassShowEnemies",1);
	setDvar("fx_draw", 1);
	//setDvar("fx_enable", "0");
	setdvar("cg_overheadIconSize","0.7");
	setdvar("cg_overheadNamesSize","0.5");
	setdvar("cg_overheadRankSize","0.5");
	setdvar("cg_drawFriendlyNames",1);
}

SetTeamNames()
{
	setdvarifuninitialized("g_TeamName_Allies", "^2Humans");
	setdvarifuninitialized("g_TeamIcon_Allies", "cardicon_taskforcearmy01");
	setdvarifuninitialized("g_TeamIcon_MyAllies", "cardicon_taskforcearmy01");
	setdvarifuninitialized("g_TeamIcon_EnemyAllies", "cardicon_taskforcearmy01");
	setdvarifuninitialized("g_TeamName_Axis", "^1Zombies");
	setdvarifuninitialized("g_TeamIcon_Axis", "cardicon_ghillie");
	setdvarifuninitialized("g_TeamIcon_MyAxis", "cardicon_ghillie");
	setdvarifuninitialized("g_TeamIcon_EnemyAxis", "cardicon_ghillie");
}


GetZombieBody()
{
	rModel = "";
	switch( getDvar("mapname") )
	{
		case "mp_underpass": rModel = "mp_body_op_sniper_ghillie_forest";
		break;
		case "mp_quarry": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_afghan": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_strike": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_rust": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_boneyard": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_trailerpark": rModel = "mp_body_opforce_arab_lmg_a";
		break;
		case "mp_derail": rModel = "mp_body_ally_sniper_ghillie_arctic";
		break;
		case "mp_compact": rModel = "mp_body_opforce_arctic_lmg_c";
		break;
		case "mp_highrise": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_terminal": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_complex": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_brecourt": rModel = "mp_body_ally_sniper_ghillie_forest";
		break;
		case "mp_nightshift": rModel = "mp_body_op_sniper_ghillie_urban";
		break;
		case "mp_estate": rModel = "mp_body_op_sniper_ghillie_forest";
		break;
		case "mp_favela": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_invasion": rModel = "mp_body_op_sniper_ghillie_urban";
		break;
		case "mp_checkpoint": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_subbase": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_rundown": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_abandon": rModel = "mp_body_ally_sniper_ghillie_urban";
		break;
		case "mp_vacant": rModel = "mp_body_op_sniper_ghillie_urban";
		break;
		case "mp_storm": rModel = "mp_body_op_sniper_ghillie_urban";
		break;
		case "mp_fuel2": rModel = "mp_body_ally_sniper_ghillie_desert";
		break;
		case "mp_overgrown": rModel = "mp_body_op_sniper_ghillie_forest";
		break;
		case "mp_crash": rModel = "mp_body_op_sniper_ghillie_urban";
		break;
	}
	return rModel;
}

hz_endgame(var_0, var_1, var_2){
	if ( !isdefined( var_2 ) )
        var_2 = 0;

    game["state"] = "postgame";
    setdvar( "ui_game_state", "postgame" );
    level.gameendtime = gettime();
    level.gameended = 1;
    level.ingraceperiod = 0;
    level notify( "game_ended", var_0 );
    maps\mp\_utility::levelflagset( "game_over" );
    maps\mp\_utility::levelflagset( "block_notifies" );
    var_3 = maps\mp\gametypes\_gamelogic::getgameduration();
    setomnvar( "ui_game_duration", var_3 * 1000 );
    maps\mp\_utility::setgameplayactive( 0 );
    waitframe();
    setgameendtime( 0 );
    setmatchdata( "gameLengthSeconds", var_3 );
    setmatchdata( "endTimeUTC", getsystemtime() );
    maps\mp\gametypes\_gamelogic::checkgameendchallenges();

    if ( isdefined( var_0 ) && isstring( var_0 ) && maps\mp\_utility::isovertimetext( var_0 ) )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        maps\mp\gametypes\_gamelogic::endgameovertime( var_0, var_1 );
        return;
    }

    if ( isdefined( var_0 ) && isstring( var_0 ) && var_0 == "halftime" )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        maps\mp\gametypes\_gamelogic::endgamehalftime( var_1 );
        return;
    }

    if ( isdefined( level.finalkillcam_winner ) )
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();

    game["roundsPlayed"]++;

    if ( level.gametype != "ctf" )
        setomnvar( "ui_current_round", game["roundsPlayed"] );

    if ( level.teambased )
    {
        if ( ( var_0 == "axis" || var_0 == "allies" ) && level.gametype != "ctf" )
            game["roundsWon"][var_0]++;

        maps\mp\gametypes\_gamescore::updateteamscore( "axis" );
        maps\mp\gametypes\_gamescore::updateteamscore( "allies" );
    }
    else if ( isdefined( var_0 ) && isplayer( var_0 ) )
        game["roundsWon"][var_0.guid]++;

    maps\mp\gametypes\_gamescore::updateplacement();
    maps\mp\gametypes\_gamelogic::rankedmatchupdates( var_0 );
    maps\mp\gametypes\_gamelogic::handlekillstreaksonroundswitch( 1 );

    foreach ( var_5 in level.players )
        var_5 setclientdvar( "ui_opensummary", 1 );

    setdvar( "g_deadChat", 1 );
    setdvar( "ui_allow_teamchange", 0 );
    setdvar( "bg_compassShowEnemies", 0 );
    //freezeallplayers( 1.0, 1 );
    var_7 = game["switchedsides"];

    if ( !maps\mp\_utility::wasonlyround() && !var_2 )
    {
        maps\mp\gametypes\_gamelogic::displayroundend( var_0, var_1 );

        if ( isdefined( level.finalkillcam_winner ) )
        {
            foreach ( var_5 in level.players )
                var_5 notify( "reset_outcome" );

            level notify( "game_cleanup" );
            maps\mp\gametypes\_gamelogic::waittillfinalkillcamdone();
        }

        if ( !maps\mp\_utility::waslastround() )
        {
            maps\mp\_utility::levelflagclear( "block_notifies" );

            if ( maps\mp\gametypes\_gamelogic::checkroundswitch() )
                maps\mp\gametypes\_gamelogic::displayroundswitch( var_7 );

            foreach ( var_5 in level.players )
            {
                var_5.pers["stats"] = var_5.stats;
                var_5.pers["segments"] = var_5.segments;
            }

            level notify( "restarting" );
            game["state"] = "playing";
            setdvar( "ui_game_state", "playing" );
            map_restart( 1 );
            return;
        }

        if ( !level.forcedend )
            var_1 = maps\mp\gametypes\_gamelogic::updateendreasontext( var_0 );
    }

    if ( !isdefined( game["clientMatchDataDef"] ) )
    {
        game["clientMatchDataDef"] = "mp/clientmatchdata.ddl";
        setclientmatchdatadef( game["clientMatchDataDef"] );
    }

    maps\mp\gametypes\_missions::roundend( var_0 );
    var_0 = maps\mp\gametypes\_gamelogic::getgamewinner( var_0, 1 );

    if ( level.teambased )
    {
        setomnvar( "ui_game_victor", 0 );

        if ( var_0 == "allies" )
            setomnvar( "ui_game_victor", 2 );
        else if ( var_0 == "axis" )
            setomnvar( "ui_game_victor", 1 );
    }

    maps\mp\gametypes\_gamelogic::displaygameend( var_0, var_1 );
    var_12 = gettime();

    if ( isdefined( level.finalkillcam_winner ) && maps\mp\_utility::wasonlyround() )
    {
        foreach ( var_5 in level.players )
            var_5 notify( "reset_outcome" );

        level notify( "game_cleanup" );
        maps\mp\gametypes\_gamelogic::waittillfinalkillcamdone();
    }

    maps\mp\_utility::levelflagclear( "block_notifies" );
    level.intermission = 1;
    level notify( "spawning_intermission" );

    foreach ( var_5 in level.players )
    {
        var_5 closepopupmenu();
        var_5 closeingamemenu();
        var_5 notify( "reset_outcome" );
        var_5 setclientomnvar( "ui_toggle_final_scoreboard", 1 );
        var_5 thread maps\mp\gametypes\_playerlogic::spawnintermission();
    }

    maps\mp\gametypes\_gamelogic::processlobbydata();
    maps\mp\_skill::process();
    wait 1.0;
    maps\mp\gametypes\_gamelogic::checkforpersonalbests();
    maps\mp\gametypes\_gamelogic::updatecombatrecord();

    if ( level.teambased )
    {
        if ( var_0 == "axis" || var_0 == "allies" )
            setmatchdata( "victor", var_0 );
        else
            setmatchdata( "victor", "none" );

        setmatchdata( "alliesScore", game["teamScores"]["allies"] );
        setmatchdata( "axisScore", game["teamScores"]["axis"] );
        tournamentreportwinningteam( var_0 );
    }
    else
        setmatchdata( "victor", "none" );

    level maps\mp\_matchdata::endofgamesummarylogger();

    foreach ( var_5 in level.players )
    {
        if ( var_5 maps\mp\_utility::rankingenabled() )
            var_5 maps\mp\_matchdata::logfinalstats();

        var_5 maps\mp\gametypes\_playerlogic::logplayerstats();
    }

    setmatchdata( "host", maps\mp\gametypes\_playerlogic::truncateplayername( level.hostname ) );

    if ( maps\mp\_utility::matchmakinggame() )
    {
        setmatchdata( "playlistVersion", getplaylistversion() );
        setmatchdata( "playlistID", getplaylistid() );
        setmatchdata( "isDedicated", isdedicatedserver() );
    }

    setmatchdata( "levelMaxClients", level.maxclients );
    sendmatchdata();
    var_19 = getmatchdata( "victor" );
    maps\mp\gametypes\_gamelogic::recordendgamecomscoreevent( var_19 );

    foreach ( var_5 in level.players )
    {
        var_5.pers["stats"] = var_5.stats;
        var_5.pers["segments"] = var_5.segments;
    }

    tournamentreportendofgame();
    var_22 = 0;

    if ( isdefined( level.endgamewaitfunc ) )
        [[ level.endgamewaitfunc ]]( var_2, level.postgamenotifies, var_22, var_0 );
    else if ( !var_2 && !level.postgamenotifies )
    {
        if ( !maps\mp\_utility::wasonlyround() )
            wait(6.0 + var_22);
        else
            wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));
    }
    else
        wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));

    var_23 = "_gamelogic.gsc";
    var_24 = "all";

    if ( level.teambased && isdefined( var_0 ) )
        var_24 = var_0;

    var_25 = "undefined";

    if ( isdefined( var_1 ) )
    {
        switch ( var_1 )
        {
            case 1:
                var_25 = "MP_SCORE_LIMIT_REACHED";
                break;
            case 2:
                var_25 = "MP_TIME_LIMIT_REACHED";
                break;
            case 3:
                var_25 = "MP_PLAYERS_FORFEITED";
                break;
            case 4:
                var_25 = "MP_TARGET_DESTROYED";
                break;
            case 5:
                var_25 = "MP_BOMB_DEFUSED";
                break;
            case 6:
                var_25 = "MP_SAS_ELIMINATED";
                break;
            case 7:
                var_25 = "MP_SPETSNAZ_ELIMINATED";
                break;
            case 8:
                var_25 = "MP_SAS_FORFEITED";
                break;
            case 9:
                var_25 = "MP_SPETSNAZ_FORFEITED";
                break;
            case 10:
                var_25 = "MP_SAS_MISSION_ACCOMPLISHED";
                break;
            case 11:
                var_25 = "MP_SPETSNAZ_MISSION_ACCOMPLISHED";
                break;
            case 12:
                var_25 = "MP_ENEMIES_ELIMINATED";
                break;
            case 13:
                var_25 = "MP_MATCH_TIE";
                break;
            case 14:
                var_25 = "GAME_OBJECTIVECOMPLETED";
                break;
            case 15:
                var_25 = "GAME_OBJECTIVEFAILED";
                break;
            case 16:
                var_25 = "MP_SWITCHING_SIDES";
                break;
            case 17:
                var_25 = "MP_ROUND_LIMIT_REACHED";
                break;
            case 18:
                var_25 = "MP_ENDED_GAME";
                break;
            case 19:
                var_25 = "MP_HOST_ENDED_GAME";
                break;
            case 20:
                var_25 = "MP_PREVENT_STAT_LOSS";
                break;
            default:
                break;
        }
    }

    if ( !isdefined( var_12 ) )
        var_12 = -1;

    var_26 = 15;
    var_27 = var_26;
    var_28 = getmatchdata( "playerCount" );
    var_29 = getmatchdata( "lifeCount" );

    if ( !isdefined( level.matchdata ) )
    {
        var_30 = 0;
        var_31 = 0;
        var_32 = 0;
        var_33 = 0;
        var_34 = 0;
        var_35 = 0;
        var_36 = 0;
    }
    else
    {
        if ( isdefined( level.matchdata["botJoinCount"] ) )
            var_30 = level.matchdata["botJoinCount"];
        else
            var_30 = 0;

        if ( isdefined( level.matchdata["deathCount"] ) )
            var_31 = level.matchdata["deathCount"];
        else
            var_31 = 0;

        if ( isdefined( level.matchdata["badSpawnDiedTooFastCount"] ) )
            var_32 = level.matchdata["badSpawnDiedTooFastCount"];
        else
            var_32 = 0;

        if ( isdefined( level.matchdata["badSpawnKilledTooFastCount"] ) )
            var_33 = level.matchdata["badSpawnKilledTooFastCount"];
        else
            var_33 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgDealtCount"] ) )
            var_34 = level.matchdata["badSpawnDmgDealtCount"];
        else
            var_34 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgReceivedCount"] ) )
            var_35 = level.matchdata["badSpawnDmgReceivedCount"];
        else
            var_35 = 0;

        if ( isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
            var_36 = level.matchdata["badSpawnByAnyMeansCount"];
        else
            var_36 = 0;
    }

    var_37 = 0;
    reconevent( "script_mp_match_end: script_file %s, gameTime %d, match_winner %s, win_reason %s, version %d, joinCount %d, botJoinCount %d, spawnCount %d, deathCount %d, badSpawnDiedTooFastCount %d, badSpawnKilledTooFastCount %d, badSpawnDmgDealtCount %d, badSpawnDmgReceivedCount %d, badSpawnByAnyMeansCount %d, sightTraceMethodsUsed %d", var_23, var_12, var_24, var_25, var_27, var_28, var_30, var_29, var_31, var_32, var_33, var_34, var_35, var_36, var_37 );

    if ( isdefined( level.ishorde ) && level.ishorde )
    {
        if ( isdefined( level.zombiescompleted ) && level.zombiescompleted )
            setdvar( "cg_drawCrosshair", 1 );
    }

    level notify( "exitLevel_called" );
    exitlevel( 0 );
}